#property link          "https://www.earnforex.com/metatrader-indicators/linear-regression-channel/"
#property version       "1.01"
#property strict
#property copyright     "EarnForex.com - 2019-2021"
#property description   "A regression channel following the candles"
#property description   " "
#property description   "WARNING : You use this software at your own risk."
#property description   "The creator of these plugins cannot be held responsible for damage or loss."
#property description   " "
#property description   "Find More on EarnForex.com"
#property icon          "\\Files\\EF-Icon-64x64px.ico"

#property indicator_chart_window
#property indicator_buffers 6
#property indicator_color1 LightSeaGreen
#property indicator_color2 LightSeaGreen
#property indicator_color3 LightSeaGreen
#property indicator_type1 DRAW_LINE
#property indicator_type2 DRAW_LINE
#property indicator_type3 DRAW_LINE
#property indicator_type4 DRAW_NONE
#property indicator_type5 DRAW_NONE
#property indicator_type6 DRAW_NONE
#property indicator_width1  1
#property indicator_width2  1
#property indicator_width3  1
#property indicator_label1  "Regression Line"
#property indicator_label2  "Upper Bound"
#property indicator_label3  "Lower Bound"

/*

When using iCustom pay attention at the calculation because at every candle shift all the values will change
Buffer 1 = Main Line
Buffer 2 = Upper Line
Buffer 3 = Lower Line
Buffer 4 = Slope
Buffer 5 = Intercept
Buffer 6 = Channel Ray

*/

#include <Math\Alglib\alglib.mqh>

enum ENUM_BANDS_CALCULATION{
   RAY_HIGH_LOW=1,       //HIGH-LOW
   RAY_CLOSE_PRICE=2,    //CLOSE PRICE
};

input string Comment1="========================";   //MQLTA Regression Channel
input string IndicatorName="MQLTA-REGCH";    //Indicator Short Name

input string Comment2="========================";   //Indicator Parameters
input int RegChannelInterval=20;             //Candles To Include In The Calculation
input int RegChannelShift=1;                 //Delay In The Channel
input ENUM_BANDS_CALCULATION RegChannelLimit=RAY_CLOSE_PRICE;      //Bands Calculation Mode
bool iCustomMode=false;                //Enable iCustom Mode

double ChannelUpperBand[];
double ChannelLowerBand[];
double ChannelLine[];
double ChannelSlope[];
double ChannelIntercept[];
double ChannelRay[];

int Shift=0;


int OnInit(void){

   IndicatorSetString(INDICATOR_SHORTNAME,IndicatorName);

   OnInitInitialization();
   if(!OnInitPreChecksPass()){
      return(INIT_FAILED);
   }   

   InitialiseBuffers();

   return(INIT_SUCCEEDED);
}


int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]){

   if(CheckIfNewCandle()){
      ArrayFill(ChannelLine,0,ArraySize(ChannelLine),EMPTY_VALUE);
      ArrayFill(ChannelUpperBand,0,ArraySize(ChannelUpperBand),EMPTY_VALUE);
      ArrayFill(ChannelLowerBand,0,ArraySize(ChannelLowerBand),EMPTY_VALUE);
      ArrayFill(ChannelSlope,0,ArraySize(ChannelSlope),EMPTY_VALUE);
      ArrayFill(ChannelIntercept,0,ArraySize(ChannelIntercept),EMPTY_VALUE);
      ArrayFill(ChannelRay,0,ArraySize(ChannelRay),EMPTY_VALUE);
      int Vars=1;
      CMatrixDouble TimePrice(RegChannelInterval,Vars+1);
      for(int i=0;i<RegChannelInterval;i++){
         TimePrice[i].Set(0,i);
         TimePrice[i].Set(1,iClose(Symbol(),PERIOD_CURRENT,i+RegChannelShift));
      }
      int Info;
      CLinearModelShell LinearModel;
      CLRReportShell Ar;
      double LinearCoefficient[];
      CAlglib::LRBuild(TimePrice,RegChannelInterval,Vars,Info,LinearModel,Ar);
      CAlglib::LRUnpack(LinearModel,LinearCoefficient,Vars);
      for(int i=0;i<RegChannelInterval+RegChannelShift;i++){
         int j=i-RegChannelShift;
         ChannelSlope[i]=LinearCoefficient[0];
         ChannelIntercept[i]=LinearCoefficient[1];
         ChannelLine[i]=ChannelSlope[i]*j+ChannelIntercept[i];
      }
      double Ray=0;
      for(int i=0;i<RegChannelInterval;i++){
         int j=i+RegChannelShift;
         if(RegChannelLimit==RAY_CLOSE_PRICE){
            double RayTemp=MathAbs(iClose(Symbol(),PERIOD_CURRENT,j)-ChannelLine[j]);
            if(RayTemp>Ray){
               Ray=RayTemp;
               continue;
            }
         }
         if(RegChannelLimit==RAY_HIGH_LOW){
            double RayTemp;
            if((iHigh(Symbol(),PERIOD_CURRENT,j)-ChannelLine[j])>(ChannelLine[j]-iHigh(Symbol(),PERIOD_CURRENT,j))) RayTemp=iHigh(Symbol(),PERIOD_CURRENT,j)-ChannelLine[j];
            else RayTemp=(ChannelLine[j]-iLow(Symbol(),PERIOD_CURRENT,j));
            if(RayTemp>Ray){
               Ray=RayTemp;
               continue;
            }
         }
      }
      
      for(int i=0;i<RegChannelInterval+RegChannelShift;i++){
         int j=i-RegChannelShift;
         ChannelRay[i]=Ray;
         ChannelUpperBand[i]=ChannelLine[i]+Ray;
         ChannelLowerBand[i]=ChannelLine[i]-Ray;
      }
      
   }

   if(IsStopped()) return(0);
      
   return(rates_total);
}
  
  
void OnDeinit(const int reason){

}  


void OnInitInitialization(){

}


bool OnInitPreChecksPass(){
   if(RegChannelInterval<=0 || RegChannelShift<0){
      Print("Wrong input parameter, period and delay can't be less than zero");
      return false;
   }   
   if(Bars(Symbol(),PERIOD_CURRENT)<RegChannelInterval+RegChannelShift){
      Print("Not Enough Historical Candles");
      return false;
   }   
   return true;
}


void InitialiseHandles(){

}


void InitialiseBuffers(){
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
   ArraySetAsSeries(ChannelLine,true);
   ArraySetAsSeries(ChannelUpperBand,true);
   ArraySetAsSeries(ChannelLowerBand,true);
   ArraySetAsSeries(ChannelSlope,true);
   ArraySetAsSeries(ChannelIntercept,true);
   ArraySetAsSeries(ChannelRay,true);
   SetIndexBuffer(0,ChannelLine,INDICATOR_DATA);
   SetIndexBuffer(1,ChannelUpperBand,INDICATOR_DATA);
   SetIndexBuffer(2,ChannelLowerBand,INDICATOR_DATA);
   SetIndexBuffer(3,ChannelSlope,INDICATOR_DATA);
   SetIndexBuffer(4,ChannelIntercept,INDICATOR_DATA);
   SetIndexBuffer(5,ChannelRay,INDICATOR_DATA);
   if(iCustomMode){
      PlotIndexSetInteger(0,PLOT_DRAW_TYPE,DRAW_NONE);
      PlotIndexSetInteger(1,PLOT_DRAW_TYPE,DRAW_NONE);
      PlotIndexSetInteger(2,PLOT_DRAW_TYPE,DRAW_NONE);
      PlotIndexSetInteger(3,PLOT_DRAW_TYPE,DRAW_NONE);
      PlotIndexSetInteger(4,PLOT_DRAW_TYPE,DRAW_NONE);
   }
}


datetime NewCandleTime=TimeCurrent();
bool CheckIfNewCandle(){
   if(NewCandleTime==iTime(Symbol(),0,0)) return false;
   else{
      NewCandleTime=iTime(Symbol(),0,0);
      return true;
   }
}

